[![pipeline status](https://gitlab.com/wpdesk/wp-wpdesk-rating-petition/badges/master/pipeline.svg)](https://gitlab.com/wpdesk/wp-wpdesk-rating-petition/pipelines) 
[![coverage report](https://gitlab.com/wpdesk/wp-wpdesk-rating-petition/badges/master/coverage.svg)](https://gitlab.com/wpdesk/wp-wpdesk-rating-petition/commits/master) 
[![Latest Stable Version](https://poser.pugx.org/wpdesk/wp-wpdesk-rating-petition/v/stable)](https://packagist.org/packages/wpdesk/wp-wpdesk-rating-petition) 
[![Total Downloads](https://poser.pugx.org/wpdesk/wp-wpdesk-rating-petition/downloads)](https://packagist.org/packages/wpdesk/wp-wpdesk-rating-petition) 
[![Latest Unstable Version](https://poser.pugx.org/wpdesk/wp-wpdesk-rating-petition/v/unstable)](https://packagist.org/packages/wpdesk/wp-wpdesk-rating-petition) 
[![License](https://poser.pugx.org/wpdesk/wp-wpdesk-rating-petition/license)](https://packagist.org/packages/wpdesk/wp-wpdesk-rating-petition)

WordPress Library to ask for good rate in repository.
===================================================

### Usage

When using in shipping zones:
```php
private function init_repository_rating() {
    $time_tracker = new ShippingMethodWatcher(
        FedexShippingService::UNIQUE_ID,
        'plugin_activation_flexible-shipping-fedex/flexible-shipping-fedex.php',
        '28-11-2019',
        FedexShippingMethod::class
    );
    $this->add_hookable( $time_tracker );
    $this->add_hookable(
        new RatingPetitionNotice(
            $time_tracker,
            FedexShippingService::UNIQUE_ID,
            $this->plugin_info->get_plugin_name(),
            'https://wpde.sk/fs-fedex-rate'
        )
    );
}
```

When using in shipping method:

```php
private function init_repository_rating() {
    $time_tracker = new ShippingMethodGlobalSettingsWatcher( FedexShippingService::UNIQUE_ID );
    $this->add_hookable( $time_tracker );
    $this->add_hookable(
        new RatingPetitionNotice(
            $time_tracker,
            FedexShippingService::UNIQUE_ID,
            $this->plugin_info->get_plugin_name(),
            'https://wpde.sk/fs-fedex-rate'
        )
    );
}
```
