<?php

namespace WPDesk\RepositoryRating;

use WPDesk\PluginBuilder\Plugin\Hookable;
use WPDesk\RepositoryRating\DisplayStrategy\DisplayDecision;

/**
 * Can display text petition.
 */
class TextPetition implements Hookable {

	/**
	 * @var string
	 */
	private $display_on_action;

	/**
	 * @var DisplayDecision
	 */
	private $display_decision;

	/**
	 * @param string $display_on_action
	 * @param DisplayDecision $display_decision
	 */
	public function __construct( string $display_on_action, DisplayDecision $display_decision ) {
		$this->display_on_action = $display_on_action;
		$this->display_decision  = $display_decision;
	}


	public function hooks() {
		add_action( $this->display_on_action, [ $this, 'display_petition_if_should' ] );
	}

	public function display_petition_if_should() {
		if ( $this->display_decision->should_display() ) {

		}
	}

}