<?php

namespace Octolize\Shopify\Codeception;

use Codeception\Module\WebDriver;
use Codeception\Util\Locator;
use Exception;

class Shopify extends WebDriver
{

    public function loginAsAdmin(): void
    {
        $i    = $this;
        $isPl = false;
        if ($i->loadSessionSnapshot('admin')) {
            return;
        }
        $i->amOnUrl($this->config['admin_url']);
        try {
            $i->moveMouseOver('body', rand(1, 100), rand(1, 100));
            $i->seeInCurrentUrl(parse_url($this->config['admin_url'], PHP_URL_PATH));
        } catch (Exception $e) {
            $i->wait(rand(1, 2));
            try {
                $i->waitForText('Continue with Google', 10);
            } catch (Exception $e) {
                $i->waitForText('Kontynuuj z Google', 30);
                $isPl = true;
            }
            $i->click($isPl ? 'Kontynuuj z Google' : 'Continue with Google');
            try {
                $i->seeInCurrentUrl(parse_url($this->config['admin_url'], PHP_URL_PATH));
                $i->dontSeeInCurrentUrl('google.com');
            } catch (Exception $e) {
                try {
                    $i->waitForText($this->config['admin_username']);
                    $i->clickWithLeftButton(Locator::find('div', ['data-email' => $this->config['admin_username']]));
                    $i->seeInCurrentUrl(parse_url($this->config['admin_url'], PHP_URL_PATH));
                    $i->dontSeeInCurrentUrl('google.com');
                } catch (Exception $e) {
                    $i->wait(rand(1, 5));
                    $i->moveMouseOver('body', rand(1, 100), rand(1, 100));
                    try {
                        $i->seeElement('input[name="identifier"]');
                        $i->fillField('identifier', $this->config['admin_username']);
                        $i->click($isPl ? 'Dalej' : 'Next');
                        $i->wait(rand(1, 5));
                        $i->moveMouseOver('input[name=Passwd]', rand(1, 100), rand(1, 100));
                        $i->fillField('Passwd', $this->config['google_password']);
                        $i->click($isPl ? 'Dalej' : 'Next');
                    } catch (Exception $e) {
                        $i->wait(rand(1, 5));
                        $i->moveMouseOver('body', rand(1, 100), rand(1, 100));
                        $i->fillField('password', $this->config['google_password']);
                        $i->click($isPl ? 'Dalej' : 'Next');
                    }
                }
            }
        }
        $i->wait(rand(1, 5));
        $i->saveSessionSnapshot('admin');
    }

    public function amOnPage($page): void
    {
        parent::amOnPage($page);
        $this->loginOnFront();
    }

    public function loginOnFront(): void
    {
        $i = $this;
        try {
            $i->seeInCurrentUrl('password');
            $i->fillField('password', $this->config['store_password']);
            $i->click('button[type=submit]');
        } catch (Exception $e) {
            // do nothing
        }
    }

}
