<?php
declare(strict_types=1);

namespace WPDesk\Migrations;

use Psr\Log\LoggerInterface;

abstract class AbstractMigration {

	/** @var \wpdb */
	protected $wpdb;

	/** @var LoggerInterface */
	protected $logger;

	public function __construct( \wpdb $wpdb, LoggerInterface $logger ) {
		$this->wpdb   = $wpdb;
		$this->logger = $logger;
	}

	abstract public function up(): bool;

	public function down(): void {}

}
