<?php

namespace WPDesk\Library\WPEmail\Parser;

use Pelago\Emogrifier\CssInliner;
use Pelago\Emogrifier\HtmlProcessor\CssToAttributeConverter;
use Pelago\Emogrifier\HtmlProcessor\HtmlPruner;

class HTMLDecorator {

    public static function style_inline( $content, $styles = '' ) {
        if ( class_exists( 'DOMDocument' ) ) {
            try {
                $css_inliner  = CssInliner::fromHtml( $content )->inlineCss( $styles );
                $dom_document = $css_inliner->getDomDocument();
                HtmlPruner::fromDomDocument( $dom_document )->removeElementsWithDisplayNone();
                $content = CssToAttributeConverter::fromDomDocument( $dom_document )
                                                  ->convertCssToVisualAttributes()
                                                  ->render();
            } catch ( \Exception $e ) {
                error_log( $e->getMessage() );
            }
        } else {
            $content = '<style type="text/css">' . strip_tags( $styles ) . '</style>' . $content;
        }

        return $content;
    }

}
