<?php

namespace WPDesk\Library\WPEmail\Abstracts;

abstract class EmailAbstract implements EmailInterface {

    /**
     * Define unique email ID.
     *
     * @return string
     */
    abstract public function get_id(): string;

    /**
     * Get defined placeholders.
     *
     * @return array
     */
    public function get_placeholders(): array {

    }

    /**
     * Get email subject.
     *
     * @return string
     */
    public function get_subject(): string {

    }

    /**
     * Get email heading.
     *
     * @return string
     */
    public function get_heading(): string {

    }

    /**
     * Get valid recipients.
     *
     * @return array
     */
    public function get_recipients(): array {

    }

    /**
     * Get email headers.
     *
     * @return string
     */
    public function get_headers(): string {

    }

    /**
     * Get email attachments.
     *
     * @return array
     */
    public function get_attachments(): array {

    }

    /**
     * Get email type.
     *
     * @return string
     */
    public function get_type(): string {

    }

    /**
     * Get email content.
     *
     * @return string
     */
    public function get_content(): string {

    }

    /**
     * Send email (wywalić do osobnej klasy ;) )
     *
     * @return void
     */
    public function send(): void {
        wp_mail(
            $this->get_recipients(), $this->get_subject(), $this->get_content(), $this->get_headers(), $this->get_attachments()
        );
    }

}
