<?php

namespace WPDesk\Library\WPEmail\Abstracts;

use Exception;

abstract class EmailAbstract implements EmailInterface {

    /**
     * @var array
     */
    protected $recipients = [];

    /**
     * @var array
     */
    protected $placeholders = [];

    /**
     * @var string
     */
    protected $subject = '';

    /**
     * @var string
     */
    protected $heading = '';

    /**
     * @var array
     */
    protected $attachments = [];

    /**
     * @var string
     */
    protected $content = '';

    /**
     * @var string
     */
    protected $type = 'text/html';

    /**
     * @var array
     */
    protected $headers;

    /**
     * Define unique email ID.
     *
     * @return string
     */
    abstract public function get_id(): string;

    /**
     * Set placeholders.
     *
     * @param array $placeholders
     *
     * @return self
     */
    public function set_placeholders( array $placeholders = [] ): self {
        $this->placeholders = array_merge( $this->placeholders, $placeholders );

        return $this;
    }

    /**
     * Get defined placeholders.
     *
     * @return string[]
     */
    public function get_placeholders(): array {
        return $this->placeholders;
    }

    /**
     * Get email subject.
     *
     * @param string $subject
     *
     * @return self
     */
    public function set_subject( string $subject ): self {
        $this->subject = $subject;

        return $this;
    }

    /**
     * Get email subject.
     *
     * @return string
     * @throws Exception
     */
    public function get_subject(): string {
        if ( ! $this->subject ) {
            throw new Exception( 'Empty email subject' );
        }

        return $this->subject;
    }

    /**
     * Set email heading.
     *
     * @param string $heading
     *
     * @return self
     */
    public function set_heading( string $heading ): self {
        $this->heading = $heading;

        return $this;
    }

    /**
     * Get email heading.
     *
     * @return string
     */
    public function get_heading(): string {
        return $this->heading;
    }

    /**
     * Get valid recipients.
     *
     * @param array $recipients
     *
     * @return self
     */
    public function set_recipients( array $recipients = [] ): self {
        $this->recipients = $recipients;

        return $this;
    }

    /**
     * Get valid recipients.
     *
     * @return string[]
     */
    public function get_recipients(): array {
        return $this->recipients;
    }

    /**
     * Get email headers.
     *
     * @param array $headers
     *
     * @return self
     */
    public function set_headers( array $headers = [] ): self {
        $this->headers = $headers;

        return $this;
    }

    /**
     * Get email headers.
     *
     * @return string[]
     */
    public function get_headers(): array {
        return $this->headers;
    }

    /**
     * Set attachments.
     *
     * @param array $attachments
     *
     * @return self
     */
    public function set_attachments( array $attachments ): self {
        $this->attachments = $attachments;

        return $this;
    }

    /**
     * Get email attachments.
     *
     * @return array
     */
    public function get_attachments(): array {
        return $this->attachments;
    }

    /**
     * Set email type.
     *
     * @param string $type
     *
     * @return self
     */
    public function set_type( string $type = 'text/html' ): self {
        $this->type = $type;

        return $this;
    }

    /**
     * Get email type.
     *
     * @return string
     */
    public function get_type(): string {
        return $this->type;
    }

    /**
     * Get email content.
     *
     * @param string $content
     *
     * @return self
     */
    public function set_content( string $content ): self {
        $this->content = $content;

        return $this;
    }

    /**
     * Get email content.
     *
     * @return string
     * @throws Exception
     */
    public function get_content(): string {
        if ( ! $this->content ) {
            throw new Exception( 'Empty email content' );
        }

        return '';
    }

    /**
     * @return mixed
     */
    public function get_object() {
        return '';
    }


}
