<?php

namespace WPDesk\Library\WPEmail\Parser;

class HTMLDecorator {

    public static function style_inline( $content ) {
        if ( in_array( $this->get_content_type(), array( 'text/html', 'multipart/alternative' ), true ) ) {
            ob_start();
            wc_get_template( 'emails/email-styles.php' );
            $css = apply_filters( 'woocommerce_email_styles', ob_get_clean(), $this );

            $css_inliner_class = \Pelago\Emogrifier\CssInliner::class;

            if ( $this->supports_emogrifier() && class_exists( $css_inliner_class ) ) {
                try {
                    $css_inliner = \Pelago\Emogrifier\CssInliner::fromHtml( $content )->inlineCss( $css );

                    do_action( 'woocommerce_emogrifier', $css_inliner, $this );

                    $dom_document = $css_inliner->getDomDocument();

                    HtmlPruner::fromDomDocument( $dom_document )->removeElementsWithDisplayNone();
                    $content = CssToAttributeConverter::fromDomDocument( $dom_document )
                                                      ->convertCssToVisualAttributes()
                                                      ->render();
                } catch ( Exception $e ) {
                    $logger = wc_get_logger();
                    $logger->error( $e->getMessage(), array( 'source' => 'emogrifier' ) );
                }
            } else {
                $content = '<style type="text/css">' . $css . '</style>' . $content;
            }
        }

        return $content;
    }

}
