<?php

namespace WPDesk\Library\WPEmail;

use WPDesk\Library\WPEmail\Emails\AdminEmail;
use WPDesk\Library\WPEmail\Emails\Email;
use WPDesk\Library\WPEmail\Emails\EmailSender;
use WPDesk\Persistence\Adapter\WordPress\WordpressOptionsContainer;
use WPDesk\Persistence\Adapter\WordPress\WordpressTransientContainer;
use WPDesk\View\Renderer\SimplePhpRenderer;
use WPDesk\View\Resolver\ChainResolver;
use WPDesk\View\Resolver\DirResolver;
use WPDesk\View\Resolver\WPThemeResolver;

class Integration {

    public function __construct() {
        $chain_resolver = new ChainResolver();
        $chain_resolver->appendResolver( new WPThemeResolver( 'email_templates' ) );
        $chain_resolver->appendResolver( new DirResolver( __DIR__ . '/templates' ) );
        $renderer = new SimplePhpRenderer( $chain_resolver );

        $email_sender = new EmailSender( 'email@mojastron.pl', 'Moj sklep' );
        $email        = new Email( $renderer, [] );

        $email_sender->add_email( $email );
        $email_sender->send();

    }

}
