<?php

namespace WPDesk\Library\WPEmail\Helpers;

use Pelago\Emogrifier\CssInliner;
use Pelago\Emogrifier\HtmlProcessor\CssToAttributeConverter;
use Pelago\Emogrifier\HtmlProcessor\HtmlPruner;

class StyleInliner {

    public static function inline( string $content, string $styles = '' ): string {
        if ( class_exists( 'DOMDocument' ) ) {
            try {
                $css_inliner  = CssInliner::fromHtml( $content )->inlineCss( $styles );
                $dom_document = $css_inliner->getDomDocument();
                HtmlPruner::fromDomDocument( $dom_document )->removeElementsWithDisplayNone();
                $content = CssToAttributeConverter::fromDomDocument( $dom_document )
                                                  ->convertCssToVisualAttributes()
                                                  ->render();
            } catch ( \Exception $e ) {
                error_log( $e->getMessage() );
            }
        } else {
            $content = '<style>' . strip_tags( $styles ) . '</style>' . $content;
        }

        return $content;
    }

    /**
     * @return array|string|string[]
     */
    protected function replace_placeholders( string $string ): string {
        if ( empty( $this->placeholders ) ) {
            return $string;
        }

        return (string) str_replace( array_keys( $this->placeholders ), array_values( $this->placeholders ), $string );
    }

}
