<?php

namespace WPDesk\Library\WPEmail;

use WPDesk\Library\WPEmail\Helpers\StyleInliner;
use WPDesk\View\Renderer\Renderer;

class EmailTemplate {

    /**
     * @var Renderer
     */
    private $renderer;

    /**
     * @var array
     */
    private $template_attributes;

    public function __construct( Renderer $renderer, array $template_attributes ) {
        $this->renderer            = $renderer;
        $this->template_attributes = wp_parse_args( $template_attributes, $this->get_default_template_attributes() );
    }

    public function get_email_template( string $content ): string {
        $output = $this->renderer->render( 'html/email-header', $this->template_attributes );
        $output .= $this->renderer->render( 'html/email-content', [ 'content' => $content ] );
        $output .= $this->renderer->render( 'html/email-footer', [ 'footer' => $this->template_attributes['footer'] ] );

        return $this->css_inline( $output );
    }

    /**
     * @param string $content
     *
     * @return mixed|string
     */
    public function css_inline( string $content ): string {
        $styles = $this->renderer->render( 'html/email-styles', $this->template_attributes );

        return StyleInliner::inline( $content, $styles );
    }

    public function get_default_template_attributes(): array {
        return [
            'heading' => '',
            'logo'    => '',
            'footer'  => '',
            'primary' => '#d15291',
            'text'    => '#303030',
            'bg'      => '#f9f9f9',
            'body'    => '#ffffff',
        ];
    }

}
