<?php

namespace WPDesk\Library\WPEmail\Abstracts;

use Exception;

class Email {

    /**
     * @var array
     */
    private $recipients = [];

    /**
     * @var string
     */
    private $subject = '';

    /**
     * @var array
     */
    private $attachments = [];

    /**
     * @var string
     */
    private $content = '';

    /**
     * @var array
     */
    private $headers = [ 'Content-Type' => 'text/html' ];

    /**
     * @var string
     */
    private $from_email;

    /**
     * @var string
     */
    private $from_name;

    /**
     * @var array
     */
    private $template_attributes;

    /**
     * @param string $from_email
     *
     * @return self
     */
    public function set_from( string $from_email ): self {
        $this->from_email = $from_email;

        return $this;
    }

    /**
     * @return string
     */
    public function get_from(): string {
        return $this->from_email;
    }

    /**
     * @param string $from_name
     *
     * @return self
     */
    public function set_from_name( string $from_name ): self {
        $this->from_name = $from_name;

        return $this;
    }

    /**
     * @return string
     */
    public function get_from_name(): string {
        return wp_specialchars_decode( esc_html( $this->from_name ), ENT_QUOTES );
    }

    /**
     * @param string $subject
     *
     * @return self
     */
    public function set_subject( string $subject ): self {
        $this->subject = $subject;

        return $this;
    }

    /**
     * @return string
     * @throws Exception
     */
    public function get_subject(): string {
        return $this->subject;
    }

    /**
     * @param array $recipients
     *
     * @return self
     */
    public function set_recipients( array $recipients = [] ): self {
        $this->recipients = $recipients;

        return $this;
    }

    /**
     * @return string[]
     */
    public function get_recipients(): array {
        return $this->recipients;
    }

    public function set_header( string $header, string $value ): self {
        $this->headers[ $header ] = $value;

        return $this;
    }

    /** @return string[] */
    public function get_headers(): array {
        $result = [];
        foreach ( $this->headers as $header => $value ) {
            $result[] = "$header: $value";
        }

        return $result;
    }

    public function get_header( string $header ): string {
        return $this->headers[ $header ] ?? '';
    }

    /**
     * @param array $attachments
     *
     * @return self
     */
    public function set_attachments( array $attachments ): self {
        $this->attachments = $attachments;

        return $this;
    }

    /**
     * @return array
     */
    public function get_attachments(): array {
        return $this->attachments;
    }

    public function is_html(): bool {
        return $this->get_header( 'Content-Type' ) === 'text/html';
    }

    /**
     * @return string
     */
    public function set_content_type( $type = 'html' ): self {
        switch ( $type ) {
            case 'plain':
                $content_type = 'text/plain';
                break;
            case 'multipart':
                $content_type = 'multipart/alternative';
                break;
            default:
                $content_type = 'text/html';
        }

        $this->set_header( 'Content-Type', $content_type );

        return $this;
    }

    /**
     * @param string $content
     *
     * @return self
     */
    public function set_content( string $content ): self {
        $this->content = $content;

        return $this;
    }

    /**
     * @return string
     * @throws Exception
     */
    public function get_content(): string {
        return $this->content;
    }

    public function set_template_attributes( string $name, string $value ): self {
        $this->template_attributes[ $name ] = $value;

        return $this;
    }

    public function get_template_attributes(): array {
        return $this->template_attributes;
    }

}
