<?php

namespace WPDesk\Library\WPEmail\Abstracts;

use WPDesk\View\Renderer\Renderer;

abstract class EmailAbstract implements EmailInterface {

    /**
     * @var Renderer
     */
    private $renderer;

    public function __construct( Renderer $renderer ) {
        $this->renderer = $renderer;
    }

    /**
     * Define unique email ID.
     *
     * @return string
     */
    abstract public function get_id(): string;

    /**
     * Get defined placeholders.
     *
     * @return string[]
     */
    public function get_placeholders(): array {
        return [];
    }

    /**
     * Get email subject.
     *
     * @return string
     */
    public function get_subject(): string {
        return '';
    }

    /**
     * Get email heading.
     *
     * @return string
     */
    public function get_heading(): string {
        return '';
    }

    /**
     * Get valid recipients.
     *
     * @return string[]
     */
    public function get_recipients(): array {
        return [];
    }

    /**
     * Get email headers.
     *
     * @return string[]
     */
    public function get_headers(): array {
        return [];
    }

    /**
     * Get email attachments.
     *
     * @return array
     */
    public function get_attachments(): array {
        return [];
    }

    /**
     * Get email type.
     *
     * @return string
     */
    public function get_type(): string {
        return 'text/html';
    }

    /**
     * Get email content.
     *
     * @return string
     */
    public function get_content(): string {
        return '';
    }

    /**
     * @return mixed
     */
    public function get_object() {
        return '';
    }

    /**
     * Get email content.
     *
     * @return string
     */
    public function render(): string {
        return $this->renderer->render( dirname( __DIR__ ) . '/html/default.php', [ 'content' => $this->get_content(), 'heading' => $this->get_heading(), 'object' => $this->get_object() ] );
    }

}
