<?php

use PHPUnit\Framework\TestCase;

require_once( PLUGIN_PATH . '/classes/wpdesk/class-plugin.php' );
require_once( PLUGIN_PATH . '/classes/plugin-template-factory.php' );

class Test_WPDesk_Plugin_Template_Factory extends TestCase {
	public function setUp() {
		WP_Mock::setUp();
	}

	public function tearDown() {
		WP_Mock::tearDown();
	}

	public function testBuildForNotActivatedPlugin() {
		WP_Mock::userFunction( 'plugin_basename', [
			'return' => 'some-plugin-name'
		] );
		WP_Mock::userFunction( 'admin_url', [
			'return' => 'http://whatever.com'
		] );
		WP_Mock::userFunction( 'get_option', [
			'args' => [ 'api_._activated', '0' ],
			'return' => 'not Activated'
		] );
		WP_Mock::userFunction( 'plugin_dir_url', [
			'return' => 'whatever'
		] );
		WP_Mock::userFunction( 'trailingslashit', [
			'return_arg' => 0
		] );

		$plugin_version = '1.0';
		define( 'PLUGIN_TEMPLATE_VERSION', $plugin_version );

		$factory = new WPDesk_Plugin_Template_Factory();
		$this->assertInstanceOf( WPDesk_Plugin_Template_Plugin::class, $factory::build_plugin() );
	}
}