<?php
require_once( 'wpdesk/class-plugin.php' );

class WPDesk_Plugin_Template_Plugin extends WPDesk_Plugin_1_10 {
	/**
	 * WPDesk_Plugin_Template_Plugin constructor.
	 *
	 * @param array $plugin_data
	 */
	public function __construct( $base_file, $plugin_data ) {
		$this->plugin_namespace   = 'plugin-template';
		$this->plugin_text_domain = 'plugin-template';

		$this->plugin_has_settings  = true;
		$this->default_settings_tab = 'welcome';

		if ( is_array( $plugin_data ) && count( $plugin_data ) ) {
			if ( ! class_exists( 'WPDesk_Helper_Plugin' ) ) {
				require_once( 'wpdesk/class-helper.php' );
				add_filter( 'plugins_api', array( $this, 'wpdesk_helper_install' ), 10, 3 );
				add_action( 'admin_notices', array( $this, 'wpdesk_helper_notice' ) );
			}
			$helper = new WPDesk_Helper_Plugin( $plugin_data );
			if ( ! $helper->is_active() ) {
				$this->plugin_is_active = false;
			}
		}

		parent::__construct( $base_file, $plugin_data );

		if ( $this->plugin_is_active() ) {
			require_once 'class-plugin-template-settings-hooks.php';
			$this->settings_hooks = new WPDesk_Plugin_Template_Settings_Hooks( $this );
			$this->settings_hooks->hooks();
			$this->init();
			$this->hooks();
		}
	}

	public function init() {
	}

	public function hooks() {
		parent::hooks();
	}

	/**
	 * Helper functions
	 */

	/**
	 * Load installer for the WP Desk Helper.
	 * @return $api Object
	 */
	public function wpdesk_helper_install( $api, $action, $args ) {
		$download_url = 'http://www.wpdesk.pl/wp-content/uploads/wpdesk-helper.zip';

		if ( 'plugin_information' != $action ||
		     false !== $api ||
		     ! isset( $args->slug ) ||
		     'wpdesk-helper' != $args->slug
		) {
			return $api;
		}

		$api                = new stdClass();
		$api->name          = 'WP Desk Helper';
		$api->version       = '1.0';
		$api->download_link = esc_url( $download_url );

		return $api;
	}

	/**
	 * Display a notice if the "WP Desk Helper" plugin hasn't been installed.
	 * @return void
	 */
	public function wpdesk_helper_notice() {

		$active_plugins = apply_filters( 'active_plugins', get_option( 'active_plugins' ) );
		if ( in_array( 'wpdesk-helper/wpdesk-helper.php', $active_plugins ) ) {
			return;
		}

		$slug         = 'wpdesk-helper';
		$install_url  = wp_nonce_url( self_admin_url( 'update.php?action=install-plugin&plugin=' . $slug ), 'install-plugin_' . $slug );
		$activate_url = 'plugins.php?action=activate&plugin=' . urlencode( 'wpdesk-helper/wpdesk-helper.php' ) . '&plugin_status=all&paged=1&s&_wpnonce=' . urlencode( wp_create_nonce( 'activate-plugin_wpdesk-helper/wpdesk-helper.php' ) );

		$message = sprintf( wp_kses( __( '<a href="%s">Install the WP Desk Helper plugin</a> to activate and get updates for your WP Desk plugins.', 'wpdesk-plugin' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( $install_url ) );
		$plugins = array_keys( get_plugins() );
		foreach ( $plugins as $plugin ) {
			if ( strpos( $plugin, 'wpdesk-helper.php' ) !== false ) {
				$message = sprintf( wp_kses( __( '<a href="%s">Activate the WP Desk Helper plugin</a> to activate and get updates for your WP Desk plugins.', 'wpdesk-plugin' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( admin_url( $activate_url ) ) );
			}
		}
		echo '<div class="error fade"><p>' . $message . '</p></div>' . "\n";
	}
}