<?php
require_once( 'wpdesk/class-plugin.php' );
require_once( 'wpdesk/interface-plugin-factory.php' );
require_once( 'plugin-template-plugin.php' );


final class WPDesk_Plugin_Template_Factory implements WPDesk_Plugin_Factory_1_10 {

	const PHP_EXTENSION = '.php';

	/** @var WPDesk_Plugin_Template_Plugin */
	private static $instance = null;

	/**
	 * Builds instance of plugin. If called more than once then more than one instance is created.
	 *
	 * @return WPDesk_Plugin_Template_Plugin
	 */
	public static function build_plugin() {
		$wpdesk_plugin_template_plugin_data = array(
			'plugin'     => plugin_basename( __FILE__ ),
			'product_id' => 'WP Desk Plugin Template',
			'version'    => PLUGIN_TEMPLATE_VERSION,
			'config_uri' => admin_url( 'edit.php?post_type=inspire_invoice&page=plugin_template' )
		);

		$class_name = apply_filters( self::WPDESK_FILTER_PLUGIN_CLASS, WPDesk_Plugin_Template_Plugin::class );

		$plugin_dir = dirname( dirname( __FILE__ ) );
		$plugin_file = trailingslashit( $plugin_dir ) . basename( $plugin_dir ) . self::PHP_EXTENSION;

		return new $class_name( $plugin_file, $wpdesk_plugin_template_plugin_data );
	}

	/**
	 * Builds instance if needed and ensures there is only one instance.
	 *
	 * @return WPDesk_Plugin_Template_Plugin
	 */
	public static function get_plugin_instance() {
		if ( empty( self::$instance ) ) {
			self::$instance = self::build_plugin();
		}

		return self::$instance;
	}
}