<?php

use PHPUnit\Framework\TestCase;

require_once( PLUGIN_PATH . '/classes/wpdesk/class-plugin.php' );
require_once( PLUGIN_PATH . '/classes/plugin-template-factory.php' );

class Test_WPDesk_Plugin_Template_Factory extends TestCase {

	public function testBuildForNotActivatedPlugin() {
		$factory = new WPDesk_Plugin_Template_Factory();
		$this->assertInstanceOf( WPDesk_Plugin_Template_Plugin::class, $factory::build_plugin() );
	}

	public function testGetPluginAlwaysSingleInstance() {
		$factory = new WPDesk_Plugin_Template_Factory();
		$instanceOne = $factory::get_plugin_instance();
		$instanceTwo = $factory::get_plugin_instance();

		$this->assertInstanceOf( WPDesk_Plugin_Template_Plugin::class, $instanceOne );
		$this->assertSame($instanceOne, $instanceTwo);
	}
}