<?php
/*
	Plugin Name: WP Desk Plugin Template
	Plugin URI: https://www.wpdesk.net/products/plugin-template/
	Description: WP Desk Plugin Template
	Product: WP Desk Plugin Template
	Version: 1.0
	Author: WP Desk
	Author URI: https://www.wpdesk.net/
	Text Domain: plugin-template
	Domain Path: /languages/

	Copyright 2016 WP Desk Ltd.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

$plugin_version = '1.0';

define( 'PLUGIN_TEMPLATE_VERSION', $plugin_version );

require_once( dirname( __FILE__ ) . '/classes/wpdesk/class-requirement-checker.php' );

$requirements_checker = new WPDesk_Requirement_Checker_1_10(
	__FILE__,
	'5.5',
	'4.5',
	'2.6.14'
);
$requirements_checker
	->add_plugin_require('hello.php', 'Hello Dolly')
	->add_php_module_require('curl' )
	->add_php_setting_require('allow_url_fopen', 1);

$requirements_checker->check_requirements_and_load_plugin_deferred();