<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

/**
 * Base plugin class for WP Desk plugins
 *
 * @author Grzegorz
 *
 */
class WPDesk_Plugin_Template_Settings_Hooks {

	private $plugin;

	public function __construct( WPDesk_Plugin_1_10 $plugin ) {
		$this->plugin = $plugin;
	}

	public function hooks() {
		$func = str_replace( '-', '_', $this->plugin->get_namespace() );

		// settings menu
		add_filter( $func . '_menu', array( $this, 'settings_menu' ) );

		// settings tabs
		add_filter( $func . '_settings_tabs', array( $this, 'settings_tabs' ) );

		// unsavable tabs
		add_filter( $func . '_unsavable_tabs', array( $this, 'unsavable_tabs' ) );

		// settings sections
		add_filter( $func . '_registered_settings_sections', array( $this, 'registered_settings_sections' ) );

		// settings
		add_filter( $func . '_registered_settings', array( $this, 'registered_settings' ) );

		// custom type hook
		add_action( $func . '_thanks', array( $this, 'custom_type_thanks' ) );

	}

	public function get_text_domain() {
		return $this->plugin->get_text_domain();
	}

	public function settings_menu( array $menu ) {

		$menu['type']       = 'menu';
		$menu['parent']     = null;
		$menu['page_title'] = __( 'WP Desk Plugin Template Settings', $this->get_text_domain() );
		$menu['show_title'] = true;
		$menu['menu_title'] = __( 'Plugin template', $this->get_text_domain() );
		$menu['capability'] = 'manage_options';
		$menu['icon']       = '';
		$menu['position']   = null;

		return $menu;

	}

	public function settings_tabs() {
		$tabs = array(
			'welcome' => __( 'Welcome', 's214-settings-demo' ),
			'fields'  => __( 'Fields', 's214-settings-demo' )
		);

		return $tabs;
	}

	public function unsavable_tabs() {
		$tabs = array(
			'welcome'
		);

		return $tabs;
	}

	public function registered_settings_sections() {
		$sections = array(
			'welcome' => array(
				'main' => __( 'Welcome Aboard!', 's214-settings-demo' )
			),
			'fields'  => array(
				'text'     => __( 'Text Fields', 's214-settings-demo' ),
				'option'   => __( 'Option Fields', 's214-settings-demo' ),
				'misc'     => __( 'Misc Fields', 's214-settings-demo' ),
				'advanced' => __( 'Advanced Fields', 's214-settings-demo' )
			)
		);

		return $sections;
	}

	function custom_type_thanks() {
		$html = '<p>' . sprintf( __( 'The S214 Settings library is significantly inspired by and based on the awesome word done by %s and the team from %s, so we owe them a <strong>huge</strong> thank you!', 's214-settings-demo' ), '<a href="http://pippinsplugins.com" target="_blank">Pippin Williamson</a>', '<a href="https://easydigitaldownloads.com">Easy Digital Downloads</a>' ) . '</p>';
		$html .= '<hr />';
		$html .= '<p>' . sprintf( __( 'By the way, even though this <em>looks</em> like a %s field, it\'s actually an example of a \'hook\' field. It is created by attaching an action to the hook %s (in our case, %s).', 's214-settings-demo' ), '<a href="https://github.com/Section214/S214-Settings/wiki/Settings-Reference#descriptive_text-implements-a-descriptive-text-field" target="_blank"><code>descriptive_text</code></a>', '<a href="https://github.com/Section214/S214-Settings/wiki/Settings-Reference#hook-implements-a-custom-field-through-a-wordpress-action" target="_blank">hook</a>', '<code>{your_plugin}_{field_id}</code>', '<code>s214_settings_demo_thanks</code>' ) . '</p>';
		$html .= '<p>' . sprintf( __( 'You\'ll also note that this tab doesn\'t have a save button. This is achieved by filtering %s, and adding the slug of the tab to the returned array.', 's214-settings-demo' ), '<code>{your_plugin}_unsavable_tabs</code>' ) . '</p>';

		echo $html;
	}

	public function registered_settings( $settings ) {
		$plugin_settings = array(
			'welcome' => array(
				'main' => array(
					array(
						'id'   => 'welcome_header',
						'name' => __( 'Welcome Aboard!', 's214-settings-demo' ),
						'desc' => '',
						'type' => 'header'
					),
					array(
						'id'            => 'welcome_note',
						'name'          => '',
						'desc'          => sprintf( __( 'This plugin will attempt to familiarize you with the various things this library is capable of. Just in case it wasn\'t obvious, the "Welcome Aboard" text above is an example of a %s field, and this field is a %s field. Remember, every field takes \'id\', \'name\', \'desc\' and \'type\' arguments!', 's214-settings-demo' ), '<a href="https://github.com/Section214/S214-Settings/wiki/Settings-Reference#header-implements-a-simple-header" target="_blank"><code>header</code></a>', '<a href="https://github.com/Section214/S214-Settings/wiki/Settings-Reference#descriptive_text-implements-a-descriptive-text-field" target="_blank"><code>descriptive_text</code></a>' ),
						'type'          => 'descriptive_text',
						'tooltip_title' => __( 'Hi There!', 's214-settings-demo' ),
						'tooltip_desc'  => __( 'Other than the \'header\' and \'hook\' field types, all fields can display a tooltip. Do this by adding \'tooltip_title\' and \'tooltip_desc\' arguments to the field array.', 's214-settings-demo' )
					),
					array(
						'id'   => 'thanks',
						'name' => __( 'Thanks EDD!', 's214-settings-demo' ),
						'desc' => '',
						'type' => 'hook'
					)
				)
			),
			'fields'  => array(
				'text'     => array(
					array(
						'id'   => 'text_header',
						'name' => __( 'Text Field Examples', 's214-settings-demo' ),
						'desc' => '',
						'type' => 'header'
					),
					array(
						'id'   => 'text',
						'name' => sprintf( __( '%s Field', 's214-settings-demo' ), 'text' ),
						'desc' => sprintf( __( 'Text fields can take \'std\', \'readonly\' and \'size\' arguements. Read more about text fields %s.', 's214-settings-demo' ), '<a href="https://github.com/Section214/S214-Settings/wiki/Settings-Reference#text-implements-a-text-field" target="_blank">' . __( 'here', 's214-settings-demo' ) . '</a>' ),
						'type' => 'text',
						'std'  => 'This is a text field'
					),
					array(
						'id'   => 'textarea',
						'name' => sprintf( __( '%s Field', 's214-settings-demo' ), 'textarea' ),
						'desc' => sprintf( __( 'Textarea fields can take a \'std\' arguement. Read more about textarea fields %s.', 's214-settings-demo' ), '<a href="https://github.com/Section214/S214-Settings/wiki/Settings-Reference#textarea-implements-a-text-area" target="_blank">' . __( 'here', 's214-settings-demo' ) . '</a>' ),
						'type' => 'textarea'
					),
					array(
						'id'   => 'editor',
						'name' => sprintf( __( '%s Field', 's214-settings-demo' ), 'editor' ),
						'desc' => sprintf( __( 'Editor fields can take \'std\', \'allow_blank\', \'size\', \'wpautop\', \'buttons\' and \'teeny\' arguements. Read more about editor fields %s.', 's214-settings-demo' ), '<a href="https://github.com/Section214/S214-Settings/wiki/Settings-Reference#editor-implements-a-rich-text-editor" target="_blank">' . __( 'here', 's214-settings-demo' ) . '</a>' ),
						'type' => 'editor'
					),
					array(
						'id'   => 'html',
						'name' => sprintf( __( '%s Field', 's214-settings-demo' ), 'html' ),
						'desc' => sprintf( __( 'HTML fields can take a \'std\' arguement. Read more about HTML fields %s.', 's214-settings-demo' ), '<a href="https://github.com/Section214/S214-Settings/wiki/Settings-Reference#html-implements-a-codemirror-html-field" target="_blank">' . __( 'here', 's214-settings-demo' ) . '</a>' ),
						'type' => 'html'
					),
					array(
						'id'   => 'password',
						'name' => sprintf( __( '%s Field', 's214-settings-demo' ), 'password' ),
						'desc' => sprintf( __( 'Password fields can take \'std\' and \'size\' arguements. Read more about password fields %s.', 's214-settings-demo' ), '<a href="https://github.com/Section214/S214-Settings/wiki/Settings-Reference#password-implements-a-password-field" target="_blank">' . __( 'here', 's214-settings-demo' ) . '</a>' ),
						'type' => 'password'
					)
				),
				'option'   => array(
					array(
						'id'   => 'option_header',
						'name' => __( 'Option Field Examples', 's214-settings-demo' ),
						'desc' => '',
						'type' => 'header'
					),
					array(
						'id'   => 'checkbox',
						'name' => sprintf( __( '%s Field', 's214-settings-demo' ), 'checkbox' ),
						'desc' => sprintf( __( 'Checkbox fields only take the basic arguements. Read more about checkbox fields %s.', 's214-settings-demo' ), '<a href="https://github.com/Section214/S214-Settings/wiki/Settings-Reference#checkbox-implements-a-checkbox" target="_blank">' . __( 'here', 's214-settings-demo' ) . '</a>' ),
						'type' => 'checkbox'
					),
					array(
						'id'      => 'multicheck',
						'name'    => sprintf( __( '%s Field', 's214-settings-demo' ), 'multicheck' ),
						'desc'    => sprintf( __( 'Multicheck fields only take the basic arguements. Read more about multicheck fields %s.', 's214-settings-demo' ), '<a href="https://github.com/Section214/S214-Settings/wiki/Settings-Reference#multicheck-implements-a-multicheck-field" target="_blank">' . __( 'here', 's214-settings-demo' ) . '</a>' ),
						'type'    => 'multicheck',
						'options' => array(
							'option1' => __( 'Option 1', 's214-settings-demo' ),
							'option2' => __( 'Option 2', 's214-settings-demo' ),
							'option3' => __( 'Option 3', 's214-settings-demo' )
						)
					),
					array(
						'id'      => 'radio',
						'name'    => sprintf( __( '%s Field', 's214-settings-demo' ), 'radio' ),
						'desc'    => sprintf( __( 'Radio fields can take a \'std\' arguement. Read more about radio fields %s.', 's214-settings-demo' ), '<a href="https://github.com/Section214/S214-Settings/wiki/Settings-Reference#radio-implements-a-radio-button-list-field" target="_blank">' . __( 'here', 's214-settings-demo' ) . '</a>' ),
						'type'    => 'radio',
						'options' => array(
							'option1' => __( 'Option 1', 's214-settings-demo' ),
							'option2' => __( 'Option 2', 's214-settings-demo' ),
							'option3' => __( 'Option 3', 's214-settings-demo' )
						)
					),
					array(
						'id'      => 'select',
						'name'    => sprintf( __( '%s Field', 's214-settings-demo' ), 'select' ),
						'desc'    => sprintf( __( 'Select fields can take \'std\', \'placeholder\', \'select2\' and \'multiple\' arguements. Read more about select fields %s.', 's214-settings-demo' ), '<a href="https://github.com/Section214/S214-Settings/wiki/Settings-Reference#select-implements-a-select-field" target="_blank">' . __( 'here', 's214-settings-demo' ) . '</a>' ),
						'type'    => 'select',
						'options' => array(
							'option1' => __( 'Option 1', 's214-settings-demo' ),
							'option2' => __( 'Option 2', 's214-settings-demo' ),
							'option3' => __( 'Option 3', 's214-settings-demo' )
						)
					)
				),
				'misc'     => array(
					array(
						'id'   => 'misc_header',
						'name' => __( 'Misc Field Examples', 's214-settings-demo' ),
						'desc' => '',
						'type' => 'header'
					),
					array(
						'id'   => 'color',
						'name' => sprintf( __( '%s Field', 's214-settings-demo' ), 'color' ),
						'desc' => sprintf( __( 'Color fields can take a \'std\' arguement. Read more about color fields %s.', 's214-settings-demo' ), '<a href="https://github.com/Section214/S214-Settings/wiki/Settings-Reference#color-implements-a-color-select-field" target="_blank">' . __( 'here', 's214-settings-demo' ) . '</a>' ),
						'type' => 'color',
						'std'  => '#000000'
					),
					array(
						'id'   => 'number',
						'name' => sprintf( __( '%s Field', 's214-settings-demo' ), 'number' ),
						'desc' => sprintf( __( 'Number fields can take \'std\', \'max\', \'min\', \'step\', \'size\' and \'readonly\' arguements. Read more about number fields %s.', 's214-settings-demo' ), '<a href="https://github.com/Section214/S214-Settings/wiki/Settings-Reference#number-implements-a-number-field" target="_blank">' . __( 'here', 's214-settings-demo' ) . '</a>' ),
						'type' => 'number',
						'std'  => 1227
					),
					array(
						'id'   => 'upload',
						'name' => sprintf( __( '%s Field', 's214-settings-demo' ), 'upload' ),
						'desc' => sprintf( __( 'Upload fields can take \'std\' and \'size\' arguements. Read more about upload fields %s.', 's214-settings-demo' ), '<a href="https://github.com/Section214/S214-Settings/wiki/Settings-Reference#upload-implements-an-upload-field" target="_blank">' . __( 'here', 's214-settings-demo' ) . '</a>' ),
						'type' => 'upload'
					)
				),
				'advanced' => array(
					array(
						'id'   => 'advanced_header',
						'name' => __( 'Advanced Field Examples', 's214-settings-demo' ),
						'desc' => '',
						'type' => 'header'
					),
					array(
						'id'   => 'sysinfo',
						'name' => sprintf( __( '%s Field', 's214-settings-demo' ), 'sysinfo' ),
						'desc' => sprintf( __( 'Sysinfo fields only take the basic arguements. Read more about sysinfo fields %s.', 's214-settings-demo' ), '<a href="https://github.com/Section214/S214-Settings/wiki/Settings-Reference#sysinfo-implements-a-system-info-display-field" target="_blank">' . __( 'here', 's214-settings-demo' ) . '</a>' ),
						'type' => 'sysinfo',
						'tab'  => 'advanced'
					)
				)
			)
		);

		return array_merge( $settings, $plugin_settings );
	}

}

